<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MotifDepense extends Model 
{

    protected $table = 'motifs_depenses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('slug', 'id_entreprise', 'libelle', 'statut');
    protected $visible = array('slug', 'id_entreprise', 'libelle', 'statut');

    public function depense()
    {
        return $this->hasMany('App\Models\Depense', 'id_motifDepense');
    }

    public function entreprise()
    {
        return $this->belongsTo('App\Models\Entreprise', 'id_entreprise');
    }

}